% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tls.R
\name{sha1}
\alias{sha1}
\title{Cryptographic Hashing Using the SHA-1 Algorithm}
\usage{
sha1(x, key = NULL, convert = TRUE)
}
\arguments{
\item{x}{an object.}

\item{key}{(optional) supply a secret key to generate an HMAC. If missing or
NULL, the SHA-1 hash of 'x' is returned.}

\item{convert}{[default TRUE] logical value whether to convert the output to
a character string or keep as a raw vector. Supplying a non-logical value
will error.}
}
\value{
A raw vector or character string depending on 'convert', of byte
    length 20.
}
\description{
Returns a SHA-1 hash or HMAC of the supplied R object. Uses the optimised
    implementation from the Mbed TLS library. For secure applications, one of
    the SHA-2 algorithms such as \code{\link{sha256}} should be considered
    instead.
}
\details{
For arguments 'x' and 'key', a raw vector is hashed directly, a
    scalar character string is translated to raw before hashing, whilst all
    other objects are serialised first.

    The result of hashing is always a raw vector, which is translated to a
    character string if 'convert' is TRUE, or returned directly if 'convert'
    is FALSE.
}
\examples{
# SHA-1 hash as character string:
sha1("hello world!")

# SHA-1 hash as raw vector:
sha1("hello world!", convert = FALSE)

# Obtain HMAC:
sha1("hello world!", "SECRET_KEY")

}
