% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{cv}
\alias{cv}
\alias{wait}
\alias{wait_}
\alias{until}
\alias{until_}
\alias{cv_value}
\alias{cv_reset}
\alias{cv_signal}
\title{Condition Variables}
\usage{
cv()

wait(cv)

wait_(cv)

until(cv, msec)

until_(cv, msec)

cv_value(cv)

cv_reset(cv)

cv_signal(cv)
}
\arguments{
\item{cv}{a \sQuote{conditionVariable} object.}

\item{msec}{maximum time in milliseconds to wait for the condition variable
to be signalled.}
}
\value{
For \strong{cv}: a \sQuote{conditionVariable} object.

 For \strong{wait}: (invisibly) logical TRUE, or else FALSE if a flag has
 been set.

 For \strong{until}: (invisibly) logical TRUE if signalled, or else FALSE if
 the timeout was reached.

 For \strong{cv_value}: integer value of the condition variable.

 For \strong{cv_reset} and \strong{cv_signal}: zero (invisibly).
}
\description{
\code{cv} creates a new condition variable (protected by a mutex internal to
the object).

\code{wait} waits on a condition being signalled by completion of an
asynchronous receive or pipe event. \cr \code{wait_} is a variant that allows
user interrupts, suitable for interactive use.

\code{until} waits until a future time on a condition being signalled by
completion of an asynchronous receive or pipe event. \cr \code{until_} is a
variant that allows user interrupts, suitable for interactive use.

\code{cv_value} inspects the internal value of a condition variable.

\code{cv_reset} resets the internal value and flag of a condition variable.

\code{cv_signal} signals a condition variable.
}
\details{
Pass the \sQuote{conditionVariable} to the asynchronous receive functions
\code{\link{recv_aio}} or \code{\link{request}}. Alternatively, to be
notified of a pipe event, pass it to \code{\link{pipe_notify}}.

Completion of the receive or pipe event, which happens asynchronously and
independently of the main R thread, will signal the condition variable by
incrementing it by 1.

This will cause the R execution thread waiting on the condition variable
using \code{wait} or \code{until} to wake and continue.

For argument \sQuote{msec}, non-integer values will be coerced to integer.
Non-numeric input will be ignored and return immediately.
}
\section{Condition}{


The condition internal to this \sQuote{conditionVariable} maintains a state
(value). Each signal increments the value by 1. Each time \code{wait} or
\code{until} returns (apart from due to timeout), the value is decremented
by 1.

The internal condition may be inspected at any time using \code{cv_value} and
reset using \code{cv_reset}. This affords a high degree of flexibility in
designing complex concurrent applications.
}

\section{Flag}{


The condition variable also contains a flag that certain signalling functions
such as \code{\link{pipe_notify}} can set. When this flag has been set, all
subsequent \code{wait} calls will return logical FALSE instead of TRUE.

Note that the flag is not automatically reset, but may be reset manually
using \code{cv_reset}.
}

\examples{
cv <- cv()

\dontrun{
wait(cv) # would block until the cv is signalled
wait_(cv) # would block until the cv is signalled or interrupted
}

until(cv, 10L)
until_(cv, 10L)

cv_value(cv)

cv_reset(cv)

cv_value(cv)
cv_signal(cv)
cv_value(cv)

}
