% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{parquet_options}
\alias{parquet_options}
\title{Nanoparquet options}
\usage{
parquet_options(
  class = getOption("nanoparquet.class", "tbl"),
  use_arrow_metadata = getOption("nanoparquet.use_arrow_metadata", TRUE),
  write_arrow_metadata = getOption("nanoparquet.write_arrow_metadata", TRUE)
)
}
\arguments{
\item{class}{The extra class or classes to add to data frames created
in \code{\link[=read_parquet]{read_parquet()}}. By default nanoparquet adds the \code{"tbl"} class,
so data frames are printed differently if the pillar package is
loaded.}

\item{use_arrow_metadata}{\code{TRUE} or \code{FALSE}. If \code{TRUE}, then
\code{\link[=read_parquet]{read_parquet()}} and \code{\link[=parquet_column_types]{parquet_column_types()}} will make use of the Apache
Arrow metadata to assign R classes to Parquet columns.
This is currently used to detect factor columns, and to detect
"difftime" columns.

If this option is \code{FALSE}:
\itemize{
\item "factor" columns are read as character vectors.
\item "difftime" columns are read as real numbers, meaning one
of seconds, milliseconds, microseconds or nanoseconds. Impossible
to tell which without using the Arrow metadata.
}}

\item{write_arrow_metadata}{Whether to add the Apache Arrow types as
metadata to the file \code{\link[=write_parquet]{write_parquet()}}.}
}
\value{
List of nanoparquet options.
}
\description{
Create a list of nanoparquet options.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# the effect of using Arrow metadata
tmp <- tempfile(fileext = ".parquet")
d <- data.frame(
  fct = as.factor("a"),
  dft = as.difftime(10, units = "secs")
)
write_parquet(d, tmp)
read_parquet(tmp, options = parquet_options(use_arrow_metadata = TRUE))
read_parquet(tmp, options = parquet_options(use_arrow_metadata = FALSE))
\dontshow{\}) # examplesIf}
}
