% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot3d.hclust}
\alias{plot3d.hclust}
\title{Methods to identify and plot groups of neurons cut from an hclust object}
\usage{
\method{plot3d}{hclust}(x, k = NULL, h = NULL, groups = NULL,
  col = rainbow, ...)
}
\arguments{
\item{x}{an \code{\link{hclust}} object generated by \code{\link{nhclust}}.}

\item{k}{number of clusters to cut from \code{\link{hclust}} object.}

\item{h}{height to cut \code{\link{hclust}} object.}

\item{groups}{numeric vector of groups to plot.}

\item{col}{colours for groups (directly specified or a function).}

\item{...}{additional arguments for \code{plot3d}}
}
\value{
A list of rgl IDs for plotted objects (see \code{\link[rgl]{plot3d}}).
}
\description{
\code{plot3d.hclust} uses \code{plot3d} to plot neurons from
  each group, cut from the \code{hclust} object, by colour.
}
\details{
Note that the colours are in the order of the dendrogram as assigned
  by \code{colour_clusters}.
}
\examples{
# 20 Kenyon cells
data(kcs20, package='nat')
# calculate mean, normalised NBLAST scores
x=nblast(kcs20, kcs20, normalised=TRUE)
x=(x+t(x))/2
# note that specifying db explicitly could be avoided by use of the
# \\code{nat.default.neuronlist} option.
plot3d(hclust(as.dist(x)), k=3, db=kcs20)
}
\seealso{
\code{\link{nhclust}, \link[rgl]{plot3d}, \link{slice}, \link{colour_clusters}}
}

