% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{bridging_sequence}
\alias{bridging_sequence}
\title{Find sequence of one or more bridging registrations}
\usage{
bridging_sequence(
  sample,
  reference,
  via = NULL,
  imagedata = FALSE,
  checkboth = !imagedata,
  mustWork = FALSE
)
}
\arguments{
\item{sample}{Source template brain (e.g. IS2) that data is currently in.
Specified either as character vector or a \code{templatebrain} object.}

\item{reference}{Target template brain (e.g. IS2) that data should be
transformed into.}

\item{via}{(optional) intermediate template brain that the registration
sequence must pass through.}

\item{imagedata}{Whether \code{x} should be treated as image data (presently
only supported as a file on disk) or 3D object vertices - see details.}

\item{checkboth}{whether to look for registrations in both
directions. The default (\code{checkboth=FALSE}) will only return
registrations in the forward direction (see details).}

\item{mustWork}{whether to error out if appropriate registrations are not
found.}
}
\description{
This function is primarily intended for developer use (it is
  used inside \code{xform_brain}) but may be useful for end users.
}
\details{
When \code{checkboth=FALSE}, only registrations that can be directly
  used to map image data from sample to reference are returned. When working
  with 3D points, use \code{checkboth=TRUE}. Note that all possible
  directories will first be scanned for registrations in the preferred
  direction and then rescanned for the opposite direction if nothing is
  found.
}
\section{Registration direction}{
 When mapping points from JFRC2 -> IS2 -> FCWB
  (i.e. sample=JFRC2, via=IS2, ref=FCWB) the command line passed to CMTK's streamxform
  should look like:
\verb{streamxform -- JFRC2_IS2.list --inverse FCWB_IS2.list}
However when mapping image data
the command line for CMTK's reformatx should look like:
\verb{reformatx  -o out.nrrd --floating JFRC2.nrrd FCWB.nrrd FCWB_IS2.list --inverse JFRC2_IS2.list}
\code{bridging_sequence} produces output like \verb{
list(JFRC2 = structure(
       "/GD/dev/R/nat.flybrains/inst/extdata/bridgingregistrations/JFRC2_IS2.list",
       swap = TRUE),
     IS2 = "/GD/dev/R/nat.flybrains/inst/extdata/bridgingregistrations/FCWB_IS2.list")
}
in these circumstances, which xformpoints.cmtkreg turns into "-- JFRC2_IS2.list --inverse FCWB_IS2.list".
}

\examples{
\dontrun{
bridging_sequence(sample=JFRC2, ref=FCWB, checkboth = T)
bridging_sequence(sample=JFRC2, via=IS2, ref=FCWB, checkboth = T)
}
}
