% Generated by roxygen2 (4.0.1): do not edit by hand
\name{image.im3d}
\alias{image.im3d}
\title{Method to plot spatially calibrated image arrays}
\usage{
\method{image}{im3d}(x, xlim = NULL, ylim = NULL, zlim = NULL,
  plotdims = NULL, flipdims = "y", filled.contour = FALSE, asp = 1,
  axes = FALSE, xlab = NULL, ylab = NULL, nlevels = 20,
  levels = pretty(zlim, nlevels + 1),
  color.palette = colorRampPalette(c("navy", "cyan", "yellow", "red")),
  col = color.palette(length(levels) - 1), useRaster = NULL, ...)
}
\arguments{
  \item{x}{The im3d object containing the data to be
  plotted (\code{NA}s are allowed).}

  \item{zlim}{the minimum and maximum \code{z} values for
  which colors should be plotted, defaulting to the range
  of the finite values of \code{z}. Each of the given
  colors will be used to color an equispaced interval of
  this range. The \emph{midpoints} of the intervals cover
  the range, so that values just outside the range will be
  plotted.}

  \item{xlim,ylim}{ranges for the plotted \code{x} and
  \code{y} values, defaulting to the BoundingBox of x.}

  \item{xlab,ylab}{each a character string giving the
  labels for the x and y axis.  Default to the \sQuote{call
  names} of \code{x} or \code{y}, or to \code{""} if these
  were unspecified.}

  \item{plotdims}{Which dimensions of 3d \code{im3d} object
  to plot (character vector). Defaults to
  \code{c('x','y')}}

  \item{flipdims}{Which dimensions to flip (character
  vector). Defaults to flipping y.}

  \item{filled.contour}{Whether to use a
  \code{\link{filled.contour}} plot instead of a regular
  \code{\link{image}} plot.}

  \item{asp}{Whether to have a a square aspect ratio
  (logical, default: \code{FALSE})}

  \item{nlevels}{The number of colour levels in z}

  \item{levels}{The levels at which to break z values}

  \item{axes}{Whether to plot axes (default: \code{FALSE})}

  \item{col}{a list of colors such as that generated by
  \code{\link{rainbow}}, \code{\link{heat.colors}},
  \code{\link{topo.colors}}, \code{\link{terrain.colors}}
  or similar functions.}

  \item{color.palette}{The colour palette from which
  \code{col} will be selected.}

  \item{useRaster}{Whether to use \code{\link{rasterImage}}
  to plot images as a bitmap (much faster for large
  images). default \code{useRaster=NULL} checks
  \code{\link{dev.capabilities}} to see if raster images
  are supported.}

  \item{\dots}{graphical parameters for \code{\link{plot}}
  or \code{\link[graphics]{image}} may also be passed as
  arguments to this function.}
}
\value{
A \code{list} with elements:

\itemize{

\item{zlim}{ The z (intensity limits)}

\item{nlevels.actual}{ The actual number of plotted levels}

\item{nlevels.orig}{ The requested number of plotted
levels}

\item{levels}{ The chosen levels}

\item{colors}{ A character vector of colours} }
}
\description{
Method to plot spatially calibrated image arrays
}
\examples{
\dontrun{
LHMask=read.im3d(system.file('tests/testthat/testdata/nrrd/LHMask.nrrd',package='nat'))
image(imslice(LHMask,10), asp=TRUE)
# useRaster is appreciably quicker in most cases
image(imslice(LHMask,10), asp=TRUE, useRaster=TRUE)
}
}

