% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/neuron-plot.R
\name{plot3d.boundingbox}
\alias{plot3d.boundingbox}
\title{Plot a bounding box in 3D}
\usage{
\method{plot3d}{boundingbox}(x, ...)
}
\arguments{
\item{x}{the \code{\link{boundingbox}} object to plot.}

\item{...}{additional arguments to pass to \code{\link[rgl]{segments3d}}.}
}
\value{
A list of RGL object IDs.
}
\description{
Plot a bounding box in 3D
}
\examples{
# plot some neurons
clear3d()
# NB skipRedraw draws all neurons in one go
plot3d(kcs20, skipRedraw = TRUE)
# plot the bounding box of all the neurons
plot3d(boundingbox(kcs20))

\dontrun{
plot3d(kcs20)
# plot bounding box (in matching colours) for each neuron
# NB makes used of nlapply/neuronlist in slightly unsusual context -
# plot3d.neuronlist can cope with lists containing anything with
# a valid plot3d method.
plot3d(nlapply(kcs20,boundingbox))
}
}
\seealso{
\code{\link{boundingbox}}
}

