% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_formula.R
\name{parse_formula}
\alias{parse_formula}
\title{Parse the nonstandard balance formulas}
\usage{
parse_formula(balance_formula, default_rhs = NULL, data = NULL)
}
\arguments{
\item{balance_formula}{a formula that may have multiple terms on the left hand side,
"." on the left hand side, and coefficients, making it not a standard formula.}

\item{default_rhs}{the list of \code{balance_formulas} can also contain entries
that are just the character corresponding to a covariate to balance. If so,
the covariate will be balanced according to \code{default_rhs}.}

\item{data}{a data frame containing the relevant covariates in the columns. The number
of rows should equal the length of \code{treated}.}
}
\value{
A named list containing \code{new_formula}: the standard formula to be used
in \code{\link{generate_constraints}}, \code{rhs_weights}: a named list with the
coefficients of the terms on the right hand side, and \code{lhs_weights}:
a named list with coefficients of the terms on the left hand side.
}
\description{
This function takes nonstandard formulas as inputs and returns regular formulas
as well as lists of weights to be used in \code{\link{generate_constraints}()}.
}
\keyword{internal}
