% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_spec_df.R
\encoding{UTF-8}
\name{create_spec_df}
\alias{create_spec_df}
\title{Create specialist data frame from character vector}
\usage{
create_spec_df(spec.char)
}
\arguments{
\item{spec.char}{a character vector with specialist names}
}
\value{
a data frame. Columns split the names, surname and abbreviation for
 the names. If the full name contain any special character, such as accent marks,
 two lines for that name will be provided, with and without the special characters.
 See examples.
}
\description{
Creates a specialist data frame ready for use in
\code{\link[naturaList]{classify_occ}}
from a character vector containing the specialists names
}
\examples{
# Example using Latin accent marks

spec_list <- iconv(
  c("Caetano Veloso", "AntÃ´nio Carlos Tom Jobim",
    "Gilberto Gil", "VinÃ­cius de Morais"),
  from = "UTF-8", to='latin1')

spec_list

create_spec_df(spec_list)

}
