% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/histpop.plot.R
\name{histpop.plot}
\alias{histpop.plot}
\title{Plots population histogram of the NCA metrics selected for model diagnosis.}
\usage{
histpop.plot(obsdata = outData, simdata = smeanData, figlbl = NULL,
  param = c("AUClast", "Cmax"), cunit = "[M].[L]^-3", tunit = "[T]",
  spread = "pi")
}
\arguments{
\item{obsdata}{Data frame with the values of the NCA metrics estimated from
the observed data}

\item{simdata}{Data frame with the values of the NCA metrics estimated from
the simulated data}

\item{figlbl}{Figure label based on dose identifier and/or population
stratifier (\strong{NULL})}

\item{param}{A character array of the NCA metrics. The allowed NCA metrics
for this histograms are "AUClast", "AUClower_upper", "AUCINF_obs",
"AUCINF_pred", "AUMClast", "Cmax", "Tmax" and "HL_Lambda_z".
(\strong{c("AUClast","Cmax")})}

\item{cunit}{Unit for concentration (\strong{"[M].[L]^-3"})}

\item{tunit}{Unit for time (\strong{"[T]"})}

\item{spread}{measure of the spread of simulated data (sd or pi (95\%
  nonparametric prediction interval)) (\strong{"pi"})}
}
\value{
returns a graphical object created by arrangeGrob function
}
\description{
\pkg{histpop.plot} plots population histogram of the NCA metrics selected
for model diagnosis (e.g. AUClast, AUCINF_obs, Cmax and Tmax).
}
\details{
\pkg{histpop.plot} plots histogram of the NCA metrics selected for the model
diagnosis and compares with the corresponding metrics estimated from the
observed data. The allowed NCA metrics for this histograms are "AUClast",
"AUClower_upper", "AUCINF_obs", "AUCINF_pred", "AUMClast", "Cmax", "Tmax" and
"HL_Lambda_z". By default, this function produces histogram of AUClast and
Cmax.
}

