\name{ndlCrossvalidate}
\alias{ndlCrossvalidate}
\title{
  Crossvalidation of a Naive Discriminative Learning model.
}
\description{
  \code{ndlCrossvalidate} undertakes a crossvalidation of a Naive
  Discriminative Learning model fitted using \code{ndlClassify}.
}
\usage{
ndlCrossvalidate(formula, data, frequency=NA, k=10, folds=NULL, \dots)

}
\arguments{
  \item{formula}{
    An object of class \code{formula} (or one that can be coerced to
    that class): a symbolic description of the model to be fitted. If
    alternatively set to \code{=NA}, the \code{data} argument is
    expected to be in the \code{ndl} internal format as generated by
    \code{\link{ndlCuesOutcomes}}, and \code{ndlCrossvalidate} will
    check that this is the case.
  }
  \item{data}{ 
    A data frame (as in \code{ndlClassify}) containing the variables
    in the \code{formula} specifying the model.
  }
  \item{frequency}{ 
    A numeric vector (or the name of a column in the input data frame)
    with the frequencies of the exemplars.  If absent, each exemplar
    is assigned a frequency equal to 1.
  }
  \item{k}{
    The number of folds, by default equal to 10.
  }
  \item{folds}{
    A list of user-defined folds, each item on the list representing a
    vector of indices indicating lines in the data frame to be used
    for testing a model fitted with the rest of the data. By default
    \code{NULL}, so that the folds are determined with random
    selection by the function \code{ndlCrossvalidate}.
  }
  \item{\dots}{
   Control arguments to be passed along to auxiliary functions, in specific
   \code{\link{estimateWeights}} and/or \code{\link{estimateActivations}}.
}
}

\details{
Crossvalidation of a Naive Discriminative Learning model.
}

\value{
  A list of the class \code{"ndlCrossvalidate"} with the following components:

\describe{
  \item{\code{call}}{The call matched by \code{ndlCrossvalidate}}
  \item{\code{formula}}{The formula specified for \code{ndlCrossvalidate}}
  \item{\code{fits}}{A list of individual fits resulting from \code{ndlCrossvalidate}}
  \item{\code{k}}{The number of folds, by default equal to 10}
  \item{\code{n.total}}{The sum frequency of data points}
  \item{\code{n.train}}{The size of the training set}
  \item{\code{n.test}}{The size of of the testing set}
  \item{\code{folds}}{A list with the folds used in the crossvalidation;
   either selected at random by \code{ndlCrossvalidate} or provided by
   the user.}
}
}

\references{

Baayen, R. H. and Milin, P.  and Filipovic Durdevic, D. and Hendrix,
P. and Marelli, M., An amorphous model for morphological processing in
visual comprehension based on naive discriminative learning.
Psychological Review, 118, 438-482.

Arppe, A. and Baayen, R. H. (in prep.). Statistical modeling and the
principles of human learning.

}
\author{
Antti Arppe
}
\seealso{
\code{\link{summary.ndlCrossvalidate}, \link{ndlStatistics}, \link{ndlCuesOutcomes},
   \link{cueCoding}, \link{estimateWeights}, \link{estimateActivations}}
}

\examples{
data(think)
set.seed(314)
think <- think[sample(1:nrow(think),500),]
think.cv5 <- ndlCrossvalidate(Lexeme ~ Agent + Patient, data=think, k=5)
summary(think.cv5)
rm(think)

\dontrun{
data(think)
think.cv10 <- ndlCrossvalidate(Lexeme ~ Person + Number + Agent + Patient + Register,
   data=think, k=10)
summary(think.cv10)
}
\dontrun{
library(languageR)
data(finalDevoicing)
finDev.cv10 <- ndlCrossvalidate(Voice ~ Onset1Type + Onset2Type + VowelType *
   ConsonantType * Obstruent + Nsyll + Stress, data=finalDevoicing, k=10)
summary(finDev.cv10)

}

}

\keyword{ classif }
