% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msnburr2a_distribution.R
\name{msnburr2a}
\alias{msnburr2a}
\alias{dmsnburr2a}
\alias{pmsnburr2a}
\alias{qmsnburr2a}
\alias{rmsnburr2a}
\title{MSNBurr-IIa distribution.}
\usage{
dmsnburr2a(x, mu = 0, sigma = 1, alpha = 1, log = FALSE)

pmsnburr2a(q, mu = 0, sigma = 1, alpha = 1, lower.tail = TRUE, log.p = FALSE)

qmsnburr2a(p, mu = 0, sigma = 1, alpha = 1, lower.tail = TRUE, log.p = FALSE)

rmsnburr2a(n, mu = 0, sigma = 1, alpha = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{a location parameter.}

\item{sigma}{a scale parameter.}

\item{alpha}{a shape parameter}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p),
The default value of this parameter is FALSE.}

\item{lower.tail}{logical;if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vectors of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dmsnburr2a} gives the density, \code{pmsnburr2a} gives the distribution
function, \code{qmsnburr2a} gives the quantile function and \code{rmsnburr2a} generates
random numbers.
}
\description{
To calculate density function, distribution funcion, quantile function, and  build data from random generator function 
for the MSNBurr distribution.
}
\details{
MSNBurr-IIa Distribution 

The MSNBurr-IIa distribution with parameters \eqn{\mu}, \eqn{\sigma}, and \eqn{\alpha}
has density:
\deqn{f(x |\mu,\sigma,\alpha)=\frac{\omega}{\sigma}\exp{\left(\omega{\left(\frac{x-\mu}{\sigma}\right)}\right)}{{\left(1+\frac{\exp{\left(\omega{(\frac{x-\mu}{\sigma})}\right)}}{\alpha}\right)}^{-(\alpha+1)}}}
where \eqn{-\infty < x < \infty, -\infty < \mu< \infty, \sigma>0, \alpha>0, 
\omega = \frac{1}{\sqrt{2\pi}} {\left(1+\frac{1}{\alpha}\right)^{\alpha+1}}}
}
\examples{
library("neodistr")
dmsnburr2a(7, mu=0, sigma=1, alpha=0.1)
plot(function(x) dmsnburr2a(x, alpha=0.1), -3, 20,
main = "Right Skew MSNBurr-IIa Density ",ylab="density")
p=pmsnburr2a(4, mu=0, sigma=1, alpha=1)
p
q=qmsnburr2a(p, mu=0, sigma=1, alpha=1)
q
qmsnburr2a(0.5, mu=0, sigma=1, alpha=1)
r=rmsnburr2a(10000, mu=0, sigma=1, alpha=0.1)
head(r)
hist(r, xlab = 'MSNBurr random number', ylab = 'Frequency', 
main = 'Distribution of MSNBurr-IIa Random Number ')
}
\references{
Choir, A. S. (2020). The New Neo-Normal DDistributions and their Properties. Disertation. Institut Teknologi Sepuluh Nopember.
}
\author{
Achmad Syahrul Choir and Nur Iriawan
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
