% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomsample.R
\name{randomsample}
\alias{randomsample}
\title{Oversampling and undersampling}
\usage{
randomsample(y, x, minor = NULL, major = 1, yminor = NULL)
}
\arguments{
\item{y}{Vector of response outcome as a factor}

\item{x}{Matrix of predictors}

\item{minor}{Amount of oversampling of the minority class. If set to \code{NULL}
then all classes will be oversampled up to the number of samples in the
majority class. To turn off oversampling set \code{minor = 1}.}

\item{major}{Amount of undersampling of the majority class}

\item{yminor}{Optional character value specifying the level in \code{y} which is
to be oversampled. If \code{NULL}, this is set automatically to the class with
the smallest sample size.}
}
\value{
List containing extended matrix \code{x} of synthesised data and extended
response vector \code{y}
}
\description{
Random oversampling of the minority group(s) or undersampling of the majority
group to compensate for class imbalance in datasets.
}
\details{
\code{minor} < 1 and \code{major} > 1 are ignored.
}
