% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-class.R, R/diffnet-methods.r
\name{as_diffnet}
\alias{as_diffnet}
\alias{diffnet}
\alias{diffnet-class}
\alias{as.data.frame.diffnet}
\alias{diffnet.attrs}
\alias{diffnet.attrs<-}
\alias{diffnet.toa}
\alias{diffnet.toa<-}
\alias{plot.diffnet}
\alias{print.diffnet}
\alias{nodes}
\alias{diffnetLapply}
\alias{str.diffnet}
\alias{dimnames.diffnet}
\alias{t.diffnet}
\alias{dim.diffnet}
\title{Creates a \code{diffnet} class object}
\usage{
as_diffnet(graph, toa, t0 = min(toa, na.rm = TRUE), t1 = max(toa, na.rm =
  TRUE), vertex.dyn.attrs = NULL, vertex.static.attrs = NULL,
  id.and.per.vars = NULL, graph.attrs = NULL,
  undirected = getOption("diffnet.undirected"),
  self = getOption("diffnet.self"),
  multiple = getOption("diffnet.multiple"), name = "Diffusion Network",
  behavior = "Unspecified")

\method{as.data.frame}{diffnet}(x, row.names = NULL, optional = FALSE,
  attr.class = c("dyn", "static"), ...)

diffnet.attrs(graph, element = c("vertex", "graph"), attr.class = c("dyn",
  "static"), as.df = FALSE)

diffnet.attrs(graph, element = "vertex", attr.class = "static") <- value

diffnet.toa(graph)

diffnet.toa(graph, i) <- value

\method{plot}{diffnet}(x, y = NULL, t = 1, displaylabels = FALSE,
  vertex.col = c(adopt = "blue", noadopt = "grey"),
  gmode = ifelse(x$meta$undirected, "graph", "digraph"),
  vertex.cex = "degree", edge.col = "gray", mode = "fruchtermanreingold",
  layout.par = NULL, main = "Diffusion network in time \%d", ...)

\method{print}{diffnet}(x, ...)

nodes(graph)

diffnetLapply(graph, FUN, ...)

\method{str}{diffnet}(object, ...)

\method{dimnames}{diffnet}(x)

\method{t}{diffnet}(x)

\method{dim}{diffnet}(x)
}
\arguments{
\item{graph}{A dynamic graph (see \code{\link{netdiffuseR-graphs}}).}

\item{toa}{Numeric vector of size \eqn{n}. Times of adoption.}

\item{t0}{Integer scalar. Passed to \code{\link{toa_mat}}.}

\item{t1}{Integer scalar. Passed to \code{\link{toa_mat}}.}

\item{vertex.dyn.attrs}{Vertices dynamic attributes (see details).}

\item{vertex.static.attrs}{Vertices static attributes (see details).}

\item{id.and.per.vars}{A character vector of length 2. Optionally specified to check the
order of the rows in the attribute data.}

\item{graph.attrs}{Graph dynamic attributes (not supported yet).}

\item{undirected}{Logical scalar. When \code{TRUE} only the lower triangle of the adjacency matrix will considered (faster).}

\item{self}{Logical scalar. When \code{TRUE} autolinks (loops, self edges) are allowed (see details).}

\item{multiple}{Logical scalar. When \code{TRUE} allows multiple edges.}

\item{name}{Character scalar. Name of the diffusion network (descriptive).}

\item{behavior}{Character scalar. Name of the behavior been analyzed (innovation).}

\item{x}{A \code{diffnet} object.}

\item{row.names}{Ignored.}

\item{optional}{Ignored.}

\item{attr.class}{Character vector/scalar. Indicates the class of the attribute, either dynamic (\code{"dyn"}),
or static (\code{"static"}).}

\item{...}{In the case of \code{plot}, further arguments passed to \code{gplot},
otherwise is ignored.}

\item{element}{Character vector/scalar. Indicates what to retrieve/alter.}

\item{as.df}{Logical scalar. When TRUE returns a data.frame.}

\item{value}{In the case of \code{diffnet.toa}, replacement, otherwise see below.}

\item{i}{Indices specifying elements to replace. See \code{\link[base:Extract]{Extract}}.}

\item{y}{Ignored.}

\item{t}{Integer scalar indicating the time slice to plot.}

\item{displaylabels}{Logical scalar. When TRUE, \code{plot} shows vertex labels.}

\item{vertex.col}{Character scalar/vector. Color of the vertices.}

\item{gmode}{Character scalar. Passed to \code{\link[sna:gplot]{sna::gplot}.}}

\item{vertex.cex}{Numeric scalar/vector. Size of the vertices.}

\item{edge.col}{Character scalar/vector. Color of the edges.}

\item{mode}{Character scalar. In the case of \code{plot}, passed to
\code{\link[sna:gplot]{gplot}}.}

\item{layout.par}{Layout parameters (see details).}

\item{main}{Character. A title template to be passed to sprintf.}

\item{FUN}{a function to be passed to lapply}

\item{object}{A \code{diffnet} object.}
}
\value{
A list of class \code{diffnet} with the following elements:
\item{graph}{A list of length \eqn{T}. Containing sparse square matrices of size \eqn{n}
and class \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}}.}
\item{toa}{An integer vector of size \eqn{T} with times of adoption.}
\item{adopt, cumadopt}{Numeric matrices of size \eqn{n\times T}{n*T} as those returned
by \code{\link{toa_mat}}.}
\item{vertex.static.attrs}{If not NULL, a data frame with \eqn{n} rows with vertex static
attributes.}
\item{vertex.dyn.attrs}{A list of length \eqn{T} with data frames containing vertex attributes
throught time (dynamic).}
\item{graph.attrs}{A data frame with \eqn{T} rows.}
\item{meta}{A list of length 9 with the following elements:
\itemize{
 \item \code{type}: Character scalar equal to \code{"dynamic"}.
 \item \code{class}: Character scalar equal to \code{"list"}.
 \item \code{ids}: Character vector of size \eqn{n} with vertices' labels.
 \item \code{pers}: Integer vector of size \eqn{T}.
 \item \code{nper}: Integer scalar equal to \eqn{T}.
 \item \code{n}: Integer scalar equal to \eqn{n}.
 \item \code{self}: Logical scalar.
 \item \code{undirected}: Logical scalar.
 \item \code{multiple}: Logical scalar.
 \item \code{name}: Character scalar.
 \item \code{behavior}: Character scalar.
}
}
}
\description{
\code{diffnet} objects contain difussion networks. With adjacency
matrices and time of adoption (toa) vector as its main components, most of the
package's functions have methods for this class of objects.
}
\details{
\code{diffnet} objects hold both, static and dynamic vertex attributes. When
creating \code{diffnet} objects, these can be specified using the arguments
\code{vertex.static.attrs} and \code{vertex.dyn.attrs}; depending on whether
the attributes to specify are static or dynamic, \pkg{netdiffuseR} currently
supports the following objects:

\tabular{llr}{
\strong{Class}    \tab \strong{Dimension}               \tab \strong{Check sorting}\cr
\emph{Static attributes} \cr
\code{matrix}     \tab with \eqn{n} rows                \tab \code{id} \cr
\code{data.frame} \tab with \eqn{n} rows                \tab \code{id} \cr
\code{vector}     \tab of length \eqn{n}                \tab - \cr\cr
\emph{Dynamic attributes} \cr
\code{matrix}     \tab with \eqn{n\times T}{n * T} rows \tab \code{id}, \code{per} \cr
\code{data.frame} \tab with \eqn{n\times T}{n * T} rows \tab \code{id}, \code{per}\cr
\code{vector}     \tab of length \eqn{n\times T}{n*T}   \tab - \cr
\code{list}       \tab of length \eqn{T} with matrices or data.frames of \eqn{n} rows\tab \code{id}, \code{per}\cr
}

The last column, \strong{Check sorting}, lists the variables that
the user should specify if he wants the function to check the order of the rows
of the attributes (notice that this is not possible for the case of vectors).
By providing the name of the vertex id variable, \code{id}, and the time period
id variable, \code{per}, the function makes sure that the attribute data is
presented in the right order. See the example below. If the user does not
provide the names of the vertex id and time period variables then the function
does not check the way the rows are sorted, further it assumes that the data
is in the correct order.

Plotting is done via the function \code{\link[sna:gplot]{gplot}},
and its layout via \code{\link[sna:gplot.layout]{gplot.layout}}, both from
the (\pkg{sna}) package.

\code{vertex.cex} can either be a numeric scalar, a numeric vector or a character
scalar taking any of the following values \code{"degree"}, \code{"indegree"}, or
\code{"outdegree"}. The later will be passed to \code{\link{dgr}} to calculate
degree of the selected slice and will be normalized as

\deqn{vertex.cex = d/[max(d) - min(d)]\times 2 + .5}{vertex.cex = d/[max(d) - min(d)]* 2 + .5}

where \code{d=sqrt(dgr(graph))}.
}
\section{Auxiliary functions}{


\code{diffnet.attrs} Allows retriving network attributes. In particular, by default
returns a list of length \eqn{T} with data frames with the following columns:

\enumerate{
 \item \code{per} Indicating the time period to which the observation corresponds.
 \item \code{toa} Indicating the time of adoption of the vertex.
 \item Further columns depending on the vertex and graph attributes.
}

Each vertex static attributes' are repeated \eqn{T} times in total so that these
can be binded (\code{rbind}) to dynamic attributes.

When \code{as.df=TRUE}, this convenience function is useful as it can be used
to create event history (panel data) datasets used for model fitting.

Conversely, the replacement method allows including new vertex or graph
attributes either dynamic or static (see examples below).

\code{diffnet.toa(graph)} works as an alias of \code{graph$toa}.
The replacement method, \code{diffnet.toa<-} used as \code{diffnet.toa(graph)<-...},
is the right way of modifying times of adoption as when doing so it
 performs several checks on the time ranges, and
recalculates adoption and cumulative adoption matrices using \code{toa_mat}.

\code{nodes(graph)} is an alias for \code{graph$meta$ids}.
}

\examples{

# Creating a random graph
set.seed(123)
graph <- rgraph_ba(t=9)
graph <- lapply(1:5, function(x) graph)

# Pretty TOA
names(graph) <- 2001L:2005L
toa <- sample(c(2001L:2005L,NA), 10, TRUE)

# Creating diffnet object
diffnet <- as_diffnet(graph, toa)
diffnet
summary(diffnet)

# Plotting slice 4
plot(diffnet, t=4)

# ATTRIBUTES ----------------------------------------------------------------

# Retrieving attributes
diffnet.attrs(diffnet, "vertex", "static")

# Now as a data.frame (only static)
diffnet.attrs(diffnet, "vertex", "static", as.df = TRUE)

# Now as a data.frame (all of them)
diffnet.attrs(diffnet, as.df = TRUE)
as.data.frame(diffnet) # This is a wrapper

# Unsorted data -------------------------------------------------------------
# Loading example data
data(fakesurveyDyn)

# Creating a diffnet object
fs_diffnet <- survey_to_diffnet(
   fakesurveyDyn, "id", c("net1", "net2", "net3"), "toa", "group",
   timevar = "time", keep.isolates=TRUE, warn.coercion=FALSE)

# Now, we extract the graph data and create a diffnet object from scratch
graph <- fs_diffnet$graph
ids <- fs_diffnet$meta$ids
graph <- Map(function(g) {
  dimnames(g) <- list(ids,ids)
  g
  }, g=graph)
attrs <- diffnet.attrs(fs_diffnet, as.df=TRUE)
toa   <- diffnet.toa(fs_diffnet)

# Lets apply a different sorting to the data to see if it works
n <- nrow(attrs)
attrs <- attrs[order(runif(n)),]

# Now, recreating the old diffnet object (notice -id.and.per.vars- arg)
fs_diffnet_new <- as_diffnet(graph, toa=toa, vertex.dyn.attrs=attrs,
   id.and.per.vars = c("id", "per"))

# Now, retrieving attributes. The 'new one' will have more (repeated)
attrs_new <- diffnet.attrs(fs_diffnet_new, as.df=TRUE)
attrs_old <- diffnet.attrs(fs_diffnet, as.df=TRUE)

# Comparing elements!
tocompare <- intersect(colnames(attrs_new), colnames(attrs_old))
all(attrs_new[,tocompare] == attrs_old[,tocompare], na.rm = TRUE) # TRUE!

# diffnetLapply -------------------------------------------------------------

data(medInnovationsDiffNet)
diffnetLapply(medInnovationsDiffNet, function(x, cumadopt, ...) {sum(cumadopt)})

}
\seealso{
Default options are listed at \code{\link{netdiffuseR-options}}

Other diffnet methods: \code{\link{\%*\%}},
  \code{\link{as.array.diffnet}}, \code{\link{c.diffnet}},
  \code{\link{diffnet-arithmetic}},
  \code{\link{diffnet_index}},
  \code{\link{summary.diffnet}}

Other data management functions: \code{\link{edgelist_to_adjmat}},
  \code{\link{egonet_attrs}}, \code{\link{isolated}},
  \code{\link{survey_to_diffnet}}
}
\author{
George G. Vega Yon
}
