% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_statistics.R
\name{network_statistics}
\alias{network_statistics}
\alias{global_efficiency}
\alias{modularity}
\title{Network Statistic Functions}
\usage{
global_efficiency(Net)

modularity(Net, community.variable)
}
\arguments{
\item{Net}{Input \code{Net} object}

\item{community.variable}{character name of the node variable that represents the partition.}
}
\value{
Network statistic value
}
\description{
These functions compute a variety of network statistics on single \code{Net} objects.

\code{global_efficiency} - Computes global efficiency. Uses brainGraph implementation \insertCite{brainGraph}{netjack}. Global efficiency originally derived by \insertCite{globEff;textual}{netjack}

\code{modularity} - Computes modularity with a given community partition. Uses \code{igraph} implementation \insertCite{igraph}{netjack}. Modularity originally derived by \insertCite{mod;textual}{netjack}
}
\examples{
data(GroupA)
GroupA1_Net = as_Net(GroupA[[1]], "1", list(community = c(rep(1, 10), rep(2,10))))
global_efficiency(GroupA1_Net)
modularity(GroupA1_Net, "community")
}
\references{
\insertAllCited{}
}
