% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_apply.R
\docType{methods}
\name{to_data_frame}
\alias{to_data_frame}
\alias{to_data_frame,NetStatSet-method}
\alias{to_data_frame,NetSampleStatSet-method}
\title{Network statistics to long format dataframe}
\usage{
to_data_frame(netStatSet)

\S4method{to_data_frame}{NetStatSet}(netStatSet)

\S4method{to_data_frame}{NetSampleStatSet}(netStatSet)
}
\arguments{
\item{netStatSet}{A \code{NetStatSet} or \code{NetSampleStatSet} object}
}
\value{
A long format dataframe containing the name of the original network,
  the original network network statistic, the name of the manipulated
  network, the manipulated network network statistic and the name of the
  network statistic.
}
\description{
This function converts a \code{NetStatSet} or \code{NetSampleStatSet} into a long format
dataframe
}
\section{Methods (by class)}{
\itemize{
\item \code{NetStatSet}: Converter for NetSampleStatSet

\item \code{NetSampleStatSet}: Converter for NetSampleStatSet
}}

\examples{
data(GroupA)
GroupA_Net = as_NetSample(GroupA, 1:20, node.variables = list(community = c(rep(1, 10), rep(2,10))),
  sample.variables = list(group = c(rep(1, 10), rep(2,10))))
Jackknife_GroupA_Net = net_apply(GroupA_Net, node_jackknife)
GlobEff_GroupA_Net = net_stat_apply(Jackknife_GroupA_Net, global_efficiency)
head(to_data_frame(GlobEff_GroupA_Net))
}
