% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/transform_ilr.R
\docType{methods}
\name{univariate_ilr}
\alias{univariate_ilr}
\alias{univariate_ilr-method}
\alias{univariate_ilr,numeric-method}
\alias{univariate_ilr,matrix-method}
\title{Univariate Isometric Log-Ratios (ILR)}
\usage{
univariate_ilr(object, ...)

\S4method{univariate_ilr}{numeric}(object)

\S4method{univariate_ilr}{matrix}(object)
}
\arguments{
\item{object}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}
}
\value{
Same as \code{object}.
}
\description{
Computes univariate ILR coordinates.
}
\details{
The ILR transformation provides the coordinates of any composition with
respect to a given orthonormal basis. \code{transform_ilr()} uses the orthonormal
basis (Helmert matrix) originally defined by Egozcue \emph{et al.} (2003).
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Isometric log-ratio
ilr <- transform_ilr(coda)
plr <- transform_plr(coda)

## Inverse transformation
inv_ilr <- transform_inverse(ilr)
all.equal(coda, inv_ilr)

inv_plr <- transform_inverse(plr)
all.equal(coda, inv_plr)
}
\references{
Filzmoser, P., Hron, K. & Reimann, C. (2009). Univariate Statistical
Analysis of Environmental (Compositional) Data: Problems and Possibilities.
\emph{Science of The Total Environment}, 407(23), 6100-6108.
\doi{10.1016/j.scitotenv.2009.08.008}.

Filzmoser, P., Hron, K. & Reimann, C. (2010). The Bivariate Statistical
Analysis of Environmental (Compositional) Data. \emph{Science of The Total
Environment}, 408(19), 4230-4238. \doi{10.1016/j.scitotenv.2010.05.011}.
}
\author{
N. Frerebeau
}
\keyword{internal}
