% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesTranslate}
\alias{nhanesTranslate}
\title{Translates code to it's text value}
\usage{
nhanesTranslate(nh_surveygroup, colname)
}
\arguments{
\item{nh_surveygroup}{The survey group that contains the columns to be translated.}

\item{colname}{The name of the column to translate}
}
\value{
The code translation
}
\description{
Many of the NHANES data tables have encoded values. E.g. 1 = 'Male', 2 = 'Female'
We want to access the code as needed either by simply displaying the code translation,
or applying the translation directly to the table. E.g, for gender we may want to
translate the code (1,2) to the represented values (Male, Female).
}
\details{
Any coded column will have a specific data code, and many columns may share the same code translation.

Code translations are done internally in the nhanes package. Specifically, the translations
are indicated in the nhanesCodeMapXXXXX lists.
}
\examples{
nhanesTranslate('DEMO', 'DMQADFC')
nhanesTranslate('LAB', 'DCD030')
}

