% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nhdplushr.R
\name{make_standalone}
\alias{make_standalone}
\title{Make isolated NHDPlusHR region a standalone dataset}
\usage{
make_standalone(flowlines)
}
\arguments{
\item{flowlines}{sf data.frame of NHDPlusHR flowlines.}
}
\description{
Cleans up and prepares NHDPlusHR regional data for use as complete NHDPlus
data. The primary modification applied is to ensure that any flowpath that exits the
domain is labeled as a terminal path and attributes are propogated upstream such that
the domain is independently complete.
}
\examples{
\donttest{
library(dplyr)
library(sf)
source(system.file("extdata/nhdplushr_data.R", package = "nhdplusTools"))

(outlet <- filter(hr_data$NHDFlowline, Hydroseq == min(Hydroseq)))
nrow(filter(hr_data$NHDFlowline, TerminalPa == outlet$Hydroseq))

hr_data$NHDFlowline <- make_standalone(hr_data$NHDFlowline)

(outlet <- filter(hr_data$NHDFlowline, Hydroseq == min(Hydroseq)))
nrow(filter(hr_data$NHDFlowline, TerminalPa == outlet$Hydroseq))

source(system.file("extdata/nhdplushr_data.R", package = "nhdplusTools"))

# Remove mainstem and non-dendritic stuff.
subset <- filter(hr_data$NHDFlowline,
                        StreamLeve > min(hr_data$NHDFlowline$StreamLeve) &
                          StreamOrde == StreamCalc)

subset <- subset_nhdplus(subset$COMID, nhdplus_data = hr_gpkg)$NHDFlowline

plot(sf::st_geometry(hr_data$NHDFlowline))

flowline_mod <- make_standalone(subset)

terminals <- unique(flowline_mod$TerminalPa)

colors <- sample(hcl.colors(length(terminals), palette = "Zissou 1"))

for(i in 1:length(terminals)) {
  fl <- flowline_mod[flowline_mod$TerminalPa == terminals[i], ]
  plot(st_geometry(fl), col = colors[i], lwd = 2, add = TRUE)
}

ol <- filter(flowline_mod, TerminalFl == 1 & TerminalPa \%in\% terminals)

plot(st_geometry(ol), lwd = 2, add = TRUE)
}
}
