% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_nhdplus.R
\name{prepare_nhdplus}
\alias{prepare_nhdplus}
\title{Prep NHDPlus Data}
\usage{
prepare_nhdplus(
  flines,
  min_network_size,
  min_path_length,
  min_path_size = 0,
  purge_non_dendritic = TRUE,
  warn = TRUE,
  error = TRUE
)
}
\arguments{
\item{flines}{data.frame NHDPlus flowlines including:
COMID, LENGTHKM, FTYPE, TerminalFl, FromNode, ToNode, TotDASqKM,
StartFlag, StreamOrde, StreamCalc, TerminalPa, Pathlength,
and Divergence variables.}

\item{min_network_size}{numeric Minimum size (sqkm) of drainage network
to include in output.}

\item{min_path_length}{numeric Minimum length (km) of terminal level
path of a network.}

\item{min_path_size}{numeric Minimum size (sqkm) of outlet level
path of a drainage basin. Drainage basins with an outlet drainage area
smaller than this will be removed.}

\item{purge_non_dendritic}{boolean Should non dendritic paths be removed
or not.}

\item{warn}{boolean controls whether warning an status messages are printed}

\item{error}{boolean controls whether to return potentially invalid data with a warning rather than an error}
}
\value{
data.frame ready to be used with the refactor_flowlines function.
}
\description{
Function to prep NHDPlus data for use by nhdplusTools functions
}
\examples{
flines_in <- sf::read_sf(system.file("extdata/petapsco_flowlines.gpkg",
                                     package = "nhdplusTools"))
prepare_nhdplus(flines_in,
                min_network_size = 10,
                min_path_length = 1,
                warn = FALSE)

}
\concept{refactor functions}
