% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSI.R
\name{BSI}
\alias{BSI}
\title{BSI - Bare Soil Index}
\usage{
BSI(B, R, NIR, SWIR1)
}
\arguments{
\item{B}{A raster layer object with the reflectance values for the Blue band.}

\item{R}{A raster layer object with the reflectance values for the Red band.}

\item{NIR}{A raster layer object with the reflectance values for the Near Infrared band.}

\item{SWIR1}{A raster layer object with the reflectance values for the Short Wave Infrared band.}
}
\value{
BSI - Bare Soil Index.
}
\description{
BSI can be used for soil mapping and crop identification. This index relates the Blue, Red, Near Infrared and Short Wave Infrared bands.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
BSI(x[[2]], x[[4]], x[[5]], x[[6]])

}
\references{
Rikimaru et al., 2002. Tropical forest cover density mapping. Tropical Ecology, 43, 39-47.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
