% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmpi7IeZS/filee6c3be8171f
\name{nfVar}
\alias{nfVar}
\alias{nfVar<-}
\title{Access or set a member variable of a nimbleFunction}
\usage{
nfVar(nf, varName)

nfVar(nf, varName) <- value
}
\arguments{
\item{nf}{a specialized nimbleFunction, i.e. a function returned by executing a function returned from \code{nimbleFunction} with \code{setup} arguments}

\item{varName}{a character string naming a variable in the \code{setup} function.}

\item{value}{value to set the variable to.}
}
\value{
whatever varName is in  the nimbleFunction nf.
}
\description{
Access or set a member variable of a specialized nimbleFunction, i.e. a variable passed to or created during the \code{setup} function that is used in run code or preserved by \code{setupOutputs}.  Works in R for any variable and in NIMBLE for numeric variables.
}
\details{
Internal way to access or set a member variable of a nimbleFunction created during \code{setup}.  Normally in NIMBLE code you would use \code{nf$var} instead of \code{nfVar(nf, var)}.

When \code{nimbleFunction} is called and a \code{setup} function is provided, then \code{nimbleFunction} returns a function.  That function is a generator that should be called with arguments to the \code{setup} function and returns another function with \code{run} and possibly other member functions.  The member functions can use objects created or passed to \code{setup}.  During internal processing, the NIMBLE compiler turns some cases of \code{nf$var} into \code{nfVar(nf, var)}. These provide direct access to setup variables (member data).  \code{nfVar} is not typically called by a NIMBLE user or programmer.


For internal access to methods of \code{nf}, see \code{\link{nfMethod}}.

For more information, see \code{?nimbleFunction} and the NIMBLE User Manual.
}
\examples{
nfGen1 <- nimbleFunction(
    setup = function(A) {
    B <- matrix(rnorm(4), nrow = 2)
    setupOutputs(B) ## preserves B even though it is not used in run-code
   },
   run = function() {
      print('This is A', A, '\\n')
})

nfGen2 <- nimbleFunction(
  setup = function() {
    nf1 <- nfGen1(1000)
  },
  run = function() {
      print('accessing A:', nfVar(nf1, 'A'))
      nfVar(nf1, 'B')[2,2] <<- -1000
      print('accessing B:', nfVar(nf1, 'B'))
   })

nf2 <- nfGen2()
nf2$run()
}
\author{
NIMBLE development team
}

