% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAR.R
\name{as.carCM}
\alias{as.carCM}
\title{Convert weights vector to parameters of \code{dcar_proper} distributio}
\usage{
as.carCM(adj, weights, num)
}
\arguments{
\item{adj}{vector of indices of the adjacent locations (neighbors) of each spatial location.  This is a sparse representation of the full adjacency matrix.}

\item{weights}{vector of symmetric unnormalized weights associated with each pair of adjacent locations, of the same length as adj.  This is a sparse representation of the full (unnormalized) weight matrix.}

\item{num}{vector giving the number of neighbors of each spatial location, with length equal to the total number of locations.}
}
\value{
A named list with elements \code{C} and \code{M}.  These may be used as the \code{C} and \code{M} arguments to the \code{dcar_proper} distribution.
}
\description{
Convert weights vector to \code{C} and \code{M} parameters of \code{dcar_proper} distribution
}
\details{
Given a symmetric matrix of unnormalized weights, this function will calculate corresponding values for the \code{C} and \code{M} arguments suitable for use in the \code{dcar_proper} distribution.  This function can be used to transition between usage of \code{dcar_normal} and \code{dcar_proper}, since \code{dcar_normal} uses the \code{adj}, \code{weights}, and \code{num} arguments, while \code{dcar_proper} requires \code{adj}, \code{num}, and also the \code{C} and \code{M} as returned by this function.

Here, \code{C} is a sparse vector representation of the row-normalized adjacency matrix, and \code{M} is a vector containing the conditional variance for each region.  The resulting values of \code{C} and \code{M} are guaranteed to satisfy the symmetry constraint imposed on \eqn{C} and \eqn{M}, that \eqn{M^{-1} C} is symmetric, where \eqn{M} is a diagonal matrix and \eqn{C} is the row-normalized adjacency matrix.
}
\author{
Daniel Turek
}
\seealso{
\code{\link{CAR-Normal}}, \code{\link{CAR-Proper}}
}

