% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateIntensityLocal_exp.R
\name{integrateIntensityLocal_exp}
\alias{integrateIntensityLocal_exp}
\title{Integrate the multivariate exponential intensity with local evaluation}
\usage{
integrateIntensityLocal_exp(
  lowerCoords,
  upperCoords,
  s,
  baseIntensities,
  lambda,
  numLocalWindows,
  localWindows
)
}
\arguments{
\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of a set of windows. One row for each window.}

\item{s}{Vector of x- and y-coordinates of the isotropic multivariate exponential distribution mean (AC location).}

\item{baseIntensities}{Vector of baseline intensities for all windows.}

\item{lambda}{Rate parameter of the isotropic multivariate exponential distribution.}

\item{numLocalWindows}{Number of windows that are close to the activity center}

\item{localWindows}{Vector of indices of the windows that are close to the activity center.}
}
\value{
A vector of integrated intensities over all local windows.
}
\description{
Calculate the integral of the intensity function with an isotropic multivariate exponential
kernel over a set of windows. The local evaluation technique is implemented.
}
\examples{

lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
s <- c(0.1, 0.9)
lambda <- 0.1
baseIntensities <- c(1:4)
numLocalWindows <- 2
localWindows <- c(1, 3)
integrateIntensityLocal_exp(lowerCoords, upperCoords,
                            s, baseIntensities, lambda, 
                            numLocalWindows, localWindows)

}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035
}
\author{
Cyril Milleret and Wei Zhang
}
\keyword{internal}
