% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nixtla_client_detect_anomalies.R
\name{nixtla_client_detect_anomalies}
\alias{nixtla_client_detect_anomalies}
\title{Sequential version of 'nixtla_client_detect_anomalies'
This is a private function of 'nixtlar'}
\usage{
nixtla_client_detect_anomalies(
  df,
  freq = NULL,
  id_col = "unique_id",
  time_col = "ds",
  target_col = "y",
  level = c(99),
  clean_ex_first = TRUE,
  model = "timegpt-1"
)
}
\arguments{
\item{df}{A data frame with time series data.}

\item{freq}{Frequency of the data.}

\item{id_col}{Column that identifies each series.}

\item{time_col}{Column that identifies each timestep.}

\item{target_col}{Column that contains the target variable.}

\item{level}{The confidence level (0-100) for the prediction interval used in anomaly detection. Default is 99.}

\item{clean_ex_first}{Clean exogenous signal before making the forecasts using 'TimeGPT'.}

\item{model}{Model to use, either "timegpt-1" or "timegpt-1-long-horizon". Use "timegpt-1-long-horizon" if you want to forecast more than one seasonal period given the frequency of the data.}
}
\value{
A data frame with the anomalies detected in the historical period.
}
\description{
Sequential version of 'nixtla_client_detect_anomalies'
This is a private function of 'nixtlar'
}
\examples{
\dontrun{
  nixtlar::nixtla_set_api_key("YOUR_API_KEY")
  df <- nixtlar::electricity
  fcst <- nixtlar::nixtla_client_anomaly_detection(df, id_col="unique_id")
}

}
\keyword{internal}
