% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode_njogis.R
\name{geocode_address_candidates}
\alias{geocode_address_candidates}
\title{Geocode an address and retrieve all candidates using the NJOGIS ArcGIS REST API}
\usage{
geocode_address_candidates(
  address = NULL,
  address2 = NULL,
  address3 = NULL,
  city = NULL,
  zip = NULL,
  max_results = NULL,
  crs = 4326
)
}
\arguments{
\item{address}{First line of address. Don't use the other address arguments if geocoding a single line address}

\item{address2}{Second line of address}

\item{address3}{Third line of address}

\item{city}{Name of city or municipality}

\item{zip}{5-digit ZIP code of city}

\item{max_results}{Max number of address candidates to return}

\item{crs}{Four digit coordinate reference system code. Defaults to 4326, 3424 and 4269 are also supported}
}
\value{
an sf object with geocoded address candidates for a single address
}
\description{
Geocode an address and retrieve all candidates using the NJOGIS ArcGIS REST API
}
\examples{
geocode_address_candidates(address = "33 Livingston Ave", city = "New Brunswick")
}
