% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete-terms.R
\name{complete_terms.mcmc}
\alias{complete_terms.mcmc}
\title{Complete Terms}
\usage{
\method{complete_terms}{mcmc}(x, silent = FALSE, ...)
}
\arguments{
\item{x}{An mcmc object.}

\item{silent}{A flag specifying whether to suppress warning messages.}

\item{...}{Unused}
}
\value{
The repaired and complete mcmc object.
}
\description{
Adds any absent elements to an mcmc object.
}
\details{
The terms are repaired before being completed.
Missing or invalid or inconsistent terms are dropped with a warning.
}
\examples{
mcmc <- as_mcmc(nlist(beta = matrix(1:4, nrow = 2)))
mcmc <- mcmc[, -4, drop = FALSE]
complete_terms(mcmc)
}
