% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_rats.R
\docType{data}
\name{rats}
\alias{rats}
\title{Pregnant Rat Diet Experiment}
\format{
A data frame with 32 rows and 6 columns

\describe{
\item{trt}{Treatment; c= control diet; t=treated diet}
\item{m}{Litter size after 4 days}
\item{x}{Litter size after 21 days}
\item{x1}{Indicator for trt=c}
\item{x2}{Indicator for trt=t}
\item{ID}{Rat ID}
}
}
\source{
\url{https://support.sas.com/documentation/cdl/en/statug/63033/HTML/default/viewer.htm#statug_nlmixed_sect040.htm}
}
\usage{
rats
}
\description{
16 pregnant rats have a control diet, and 16 have a chemically
treated diet.  The litter size for each rat is recorded after 4
and 21 days.  This dataset is used in the SAS Probit-model with
binomial data, and saved in the nlmixr2 package as rats.
}
\references{
Weil, C.S., 1970. Selection of the valid number of
sampling units and a consideration of their combination in
toxicological studies involving reproduction, teratogenesis or
carcinogenesis. Fd. Cosmet. Toxicol. 8, 177-182.

Williams, D.A., 1975. The analysis of binary responses
from toxicological experiments involving reproduction and
teratogenicity. Biometrics 31, 949-952.

McCulloch, C. E. (1994),
"Maximum Likelihood Variance Components Estimation for Binary Data,"
Journal of the American Statistical Association, 89, 330 -
335.

Ochi, Y. and Prentice, R. L. (1984),
"Likelihood Inference in a Correlated Probit Regression Model,"
Biometrika, 71, 531-543.
}
\seealso{
Other nlmixr2 datasets: 
\code{\link{Bolus_1CPTMM}},
\code{\link{Bolus_1CPT}},
\code{\link{Bolus_2CPTMM}},
\code{\link{Bolus_2CPT}},
\code{\link{Infusion_1CPTMM}},
\code{\link{Infusion_1CPT}},
\code{\link{Infusion_2CPTMM}},
\code{\link{Infusion_2CPT}},
\code{\link{Oral_1CPTMM}},
\code{\link{Oral_1CPT}},
\code{\link{Oral_2CPTMM}},
\code{\link{Oral_2CPT}},
\code{\link{Wang2007}},
\code{\link{mavoglurant}},
\code{\link{nimoData}},
\code{\link{nmtest}},
\code{\link{pheno_sd}},
\code{\link{theo_md}},
\code{\link{theo_sd}},
\code{\link{warfarin}},
\code{\link{wbcSim}}
}
\concept{nlmixr2 datasets}
\keyword{datasets}
