\name{nl.MLE}
\alias{nl.MLE}
\title{
  Nonlinear MLE
}
\description{
  MLE estimate of a nonlinear function. with hetro variance model function, and weights. 
}
\usage{
nl.MLE(formula, data, start = getInitial(formula, data), vm = NULL, 
rm = solve(t(chol(vm))), 
control =nlr.control(derivfree = T), 
varmodel = NULL, tau = varmodel$par, ...)
}
\arguments{
  \item{formula}{
    \code{\link{nl.form}} object of the nonlinear function model.
  }
  \item{data}{
    list of data include responce and predictor.
  }
  \item{start}{
    list of parameter values of nonlinear model function (\eqn{\theta}.
  }
  
  \item{vm}{
    optional covariance matrix.
  }
  \item{rm}{
    optional cholesky decomposition of covariance matrix.
  }
    \item{control}{
      list of \code{\link{nlr.control}} for controling convergence criterions. Defaul value of \code{derivfree} is "True", force function to use derivative free methods. But it can be "False" to use derivative based, has faster convergence.
  }

  \item{varmodel}{
      \code{nl.fomr} object of variance function model for heteroscedastic variance.
  }
  
  \item{tau}{
      list of initial values for variance model function \code{varmodel} argument.
  }
  \item{\dots}{
      extra arguments to nonlinear regression model, heteroscedastic variance function, robust loss function or its tuning constants.
  }
}
\details{
  Calculate Maximum Likelihood estimate in several sitautions, if \code{varmodel} is given the hetroscedastic variance consider. If \code{vm} or \code{rm} is given, weighted is computing.
}
\value{
  Depending given options different fitt object will result as follow
  \itemize{
    \item{if vm=NULL and varmodel=NULL}{represent homogeneous and uncorrelated erro, output is \code{\link{nl.fitt}} object generated by \code{\link{nlsqr}} or \code{\link{nlsnm}} for derivative based and derivative free method respectivly given by \code{derivfree} option.}
    
    \item{if vm=NULL and varmodel is given}{ represent heteroscedastic variance case, output is \code{\link{nl.fitt.gn}} generated by \code{\link{nl.robhetroWM}}, depends on using derivative free method or no.}
    
    \item{if vm is given}{ represent general covariance matrix as weight, ouput is \code{\link{nl.fitt.gn}} generated by \code{\link{nlsqr.gn}}.}
  }
}
\references{
Riazoshams, H,. 2010. Outlier detection and robust estimation methods for nonlinear regression having autocorrelated and heteroscedastic errors. PhD thesis disertation, University Putra Malaysia.

   Riazoshams H, Midi H, and Ghilagaber G, 2018,. Robust Nonlinear Regression, with Application using R, Joh Wiley and Sons.
}
\author{
  Hossein Riazoshams, May 2014. 
  Email: \email{riazihosein@gmail.com} 
  URL \url{http://www.riazoshams.com/nlr/}
}
\note{
  The objective function used in \code{\link{nl.robhetroWM}} is general form of Likelihood, thus it can generate Least Square estimate using quadratic function, which can be accessed in nl.robfuncs[["least square"]] variable. It can include parameteric variance function also.
  Due to compatibility it is beter to be called from \code{nlr} function rather than direct call by user.
}
\seealso{
  \code{\link{nlsqr.gn}}, \code{\link{nl.robhetroWM}},\code{\link{nl.fitt}}, \code{\link{nl.fitt.gn}}, \code{\link{nlsnm}}, \code{\link{nlsqr}}, \code{\link{nlr.control}}
}
\examples{
## The function is currently defined as
"nl.MLE"
}
\keyword{hetroscedastic error}
\keyword{Nelder-Mead optimization}
\keyword{Weighted M-estimators}
\keyword{Maximum likelihood estimate}
