% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSlogis5.R
\name{SSlogis5}
\alias{SSlogis5}
\alias{logis5}
\title{self start for five-parameter logistic function}
\usage{
logis5(x, asym1, asym2, xmid, iscal, theta)

SSlogis5(x, asym1, asym2, xmid, iscal, theta)
}
\arguments{
\item{x}{input vector (x) which is normally light intensity (PPFD, Photosynthetic Photon Flux Density).}

\item{asym1}{asymptotic value for low values of x}

\item{asym2}{asymptotic value for high values of x}

\item{xmid}{value of x at which y = (asym1 + asym2)/2}

\item{iscal}{steepness of transition from asym1 to asym2 (inverse of the scale)}

\item{theta}{asymmetry parameter, if it is equal to 1, this is the four parameter logistic}
}
\value{
a numeric vector of the same length as x (time) containing parameter estimates for equation specified

logis5: vector of the same length as x (time) using the 5-parameter logistic
}
\description{
Self starter for a five-parameter logistic function.
}
\details{
This is known as the Richards' function or the log-logistic and it is described in Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506).
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- seq(0, 2000, 100)
y <- logis5(x, 35, 10, 800, 5, 2) + rnorm(length(x), 0, 0.5)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSlogis5(x, asym1, asym2, xmid, scal, theta), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
x <- seq(0, 2000)
y <- logis5(x, 30, 10, 800, 5, 2)
plot(x, y)
}
