% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{docdb_query}
\alias{docdb_query}
\title{Get documents with a filtering query}
\usage{
docdb_query(src, key, query, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}} or \code{\link[=src_couchdb]{src_couchdb()}}}

\item{key}{(character) A key as name of the container
(corresponds to parameter \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch and to
a table name for SQLite)}

\item{query}{(character) A JSON query string, see examples}

\item{...}{Optionally, \code{fields} a JSON string of fields to
be returned from anywhere in the tree (dot paths notation).

Other parameters passed on to functions:
\itemize{
\item MongoDB: find() in \code{\link[mongolite:mongo]{mongolite::mongo()}}
\item RSQLite: for mangling into SQL query
\item Elasticsearch: \code{\link[elastic:Search]{elastic::Search()}}
\item CouchDB: \code{\link[sofa:db_query]{sofa::db_query()}}
}}
}
\value{
Data frame with requested data, may have nested
lists in columns
}
\description{
Get documents with a filtering query
}
\examples{
\dontrun{
src <- src_sqlite()
docdb_create(src, "mtcars", mtcars)
docdb_query(src, "mtcars", query = '{"mpg":21}')
docdb_query(src, "mtcars", query = '{"mpg":21}', fields = '{"mpg":1, "cyl":1}')
docdb_query(src, "mtcars", query = '{"_id": {"$regex": "^.+0.*$"}}', fields = '{"gear": 1}')
# complex query, not supported for Elasticsearch and CouchDB backends at this time:
docdb_query(src, "mtcars", query = '{"$and": [{"mpg": {"$lte": 18}}, {"gear": {"$gt": 3}}]}')
}
}
