% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nomprox.R
\name{nomprox}
\alias{nomprox}
\title{Nominal Clustering based on a Proximity Matrix}
\usage{
nomprox(data, prox_matrix, clu_low = 2, clu_high = 6, eval = TRUE,
  method = "complete")
}
\arguments{
\item{data}{data frame or a matrix with cases in rows and variables in colums. Cases are characterized by nominal (categorical) variables coded as numbers.}

\item{prox_matrix}{full proximity matrix computed using any similarity measure from the data analyzed.}

\item{clu_low}{numeric value expressing the lower bound for number of cluster solutions.}

\item{clu_high}{numeric value expressing the higher bound for number of cluster solutions.}

\item{eval}{logical operator; if TRUE, there is performed an evaluation of clustering results}

\item{method}{character string defining the clustering method. The following methods can be used: \code{"average"}, \code{"complete"}, \code{"single"}.}
}
\value{
Function returns a data frame, where the rows express a serie of cluster solutions and columns
clustering evaluation statistics in a following order: \code{WCM}, \code{WCE}, \code{PSTau}, \code{PSU}, \code{PSFM}, \code{PSFE}.
}
\description{
Based on the original dataset and the proximity matrix, the function computes cluster membership variables for a user-defined number of cluster solutions. 
Optionally, it evaluates clustering results using six evaluation criteria based on the within-cluster variability:
Within-cluster mutability coefficient (WCM), Within-cluster entropy coefficient (WCE),
Pseudo tau coefficient (PSTau), Pseudo uncertainty coefficient (PSU) and Pseudo F, Indices based on the mutability (PSFM) and the entropy (PSFE).
}
\examples{
#sample data
data(data20)
#computation of a proximity matrix using the iof similarity measure
matrix <- iof(data20)
#creation of a dataset with cluster memberships
hca <- nomprox(data20, matrix, clu_high = 5, method = "complete")
#getting evaluation statistics
eval <- hca$eval
#getting cluster membership variables
mem <- hca$mem 

}
\seealso{
\code{\link[nomclust]{nomclust}}, \code{\link[nomclust]{evalclust}}.
}

