% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iof.R
\name{iof}
\alias{iof}
\title{Inverse Occurence Frequency (IOF) Measure}
\usage{
iof(data)
}
\arguments{
\item{data}{A data.frame or a matrix with cases in rows and variables in colums.}
}
\value{
The function returns an object of the class "dist".
\cr
}
\description{
The function calculates a dissimilarity matrix based on the IOF similarity measure.
\cr
}
\details{
The IOF (Inverse Occurrence Frequency) measure was originally constructed for the text mining tasks,
see (Sparck-Jones, 1972), later, it was adjusted for categorical variables, see (Boriah et al., 2008).
The measure assigns higher weight to mismatches on less frequent values and vice versa.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.iof <- iof(data20)

}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
 \cr
 \cr
Spark-Jones K. (1972). A statistical interpretation of term specificity and its application in retrieval.
In Journal of Documentation, 28(1), 11-21. Later: Journal of Documentation, 60(5) (2002), 493-502.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good3}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
