% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nonLinearSystems.R
\name{henon}
\alias{henon}
\title{Henon map}
\usage{
henon(start = runif(min = -0.5, max = 0.5, n = 2), a = 1.4, b = 0.3,
  n.sample = 5000, n.transient = 500, do.plot = TRUE)
}
\arguments{
\item{start}{A 2-dimensional vector indicating the starting values for the x and y Henon coordinates.
If the starting point is not specified, it is generated randomly.}

\item{a}{The \emph{a} parameter. Default: 1.4.}

\item{b}{The \emph{b} parameter. Default: 0.3.}

\item{n.sample}{Length of the generated time series. Default: 5000 samples.}

\item{n.transient}{Number of transient samples that will be discarded. Default: 500 samples.}

\item{do.plot}{Logical value. If TRUE (default value), a plot of the generated Henon system is shown.}
}
\value{
A list with two vectors named \emph{x} and \emph{y} containing the x-components and the
y-components of the Henon map, respectively.
}
\description{
Generates a 2-dimensional time series using the Henon map.
}
\details{
The Henon map is defined as follows:
\deqn{ x_n = 1 - a \cdot x_{n - 1}^2 + y_{n - 1}}{x[n] = 1 - a*x[n - 1]^2 + y[n - 1]}
\deqn{ y_n = b \cdot x_{n - 1}}{y[n] = b*x[n - 1].}
The default selection for both \emph{a} and \emph{b} parameters (\emph{a}=1.4 and \emph{b}=0.3) is known to
produce a deterministic chaotic time series.
}
\note{
Some initial values may lead to an unstable system that will tend to infinity.
}
\examples{
\dontrun{
henon.map=henon(n.sample = 1000, n.transient=10,do.plot=TRUE,
               start=c(-0.006423277,-0.473545134))
# accessing the x coordinate and plotting it
plot(ts(henon.map$x))
}
}
\author{
Constantino A. Garcia
}
\references{
Strogatz, S.: Nonlinear dynamics and chaos: with applications to physics, biology, chemistry and engineering (Studies in Nonlinearity)
}
\seealso{
\code{\link{logisticMap}, \link{lorenz}, \link{rossler}, \link{ikedaMap}, \link{cliffordMap}, \link{sinaiMap}, \link{gaussMap}}
}

