% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadNonmemOutput.R
\name{covload}
\alias{covload}
\title{Load the covariance matrix from a nonmem .cov output file.}
\usage{
covload(model, use.model.path = TRUE, theta.only = T)
}
\arguments{
\item{model}{name of the cov file with or without the .cov extension. model may include full or relative path to the cov file. See examples.}

\item{use.model.path}{Load file from a global defined model library (TRUE=default).
If so will look for a global character vector named \code{model.path}}

\item{theta.only}{return covariance matrix of theta's only (default)}
}
\value{
the covariance matrix
}
\description{
Load the covariance matrix from a nonmem .cov output file.
Either the covariance matrix of all THETA parameters (default) or the covariance matrix of all parameters, THETA, OMEGA and SIGMA.
}
\examples{
##### Load the .cov file "run001.cov"
# 1) Get path to the example file included in nonmem2R package
file1 <- system.file("extdata", "run001.cov", package = "nonmem2R")
# 2) Load the file using the covload function
covload(file1)
}

