% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadNonmemOutput.R
\name{systemPSN}
\alias{systemPSN}
\title{Run qpsn system call}
\usage{
systemPSN(cmd, use.model.path = TRUE, ...)
}
\arguments{
\item{cmd}{qpsn cmd}

\item{use.model.path}{Run cmd in a specified model library (TRUE=default).
If so will look for a global character vector named \code{model.path} and
run the system cmd the folder path as specified in \code{model.path}.}

\item{...}{Further arguments}
}
\description{
Run qpsn system call on system where psn is available.
If psn is not available system{base} is used.
}
\examples{
# (if the platform has who)
try(systemPSN("who", intern = TRUE))

try(systemPSN("ls fizzlipuzzli", intern = TRUE, ignore.stderr = TRUE))
# zero-length result since file does not exist, and will give warning.
}

