% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_GOFs.R
\name{qqnormGOF}
\alias{qqnormGOF}
\title{QQ-norm GOF}
\usage{
qqnormGOF(data, x, title = "", color = "", fx = NULL,
  refline = TRUE, control = GOF.control())
}
\arguments{
\item{data}{data.frame to plot}

\item{x}{character string with name of column for x}

\item{title}{title}

\item{color}{data columns to set different colors in plot, interpreted as factor}

\item{fx}{function for transformation of x before plotting}

\item{refline}{add reference line (default =TRUE) or not (FALSE)}

\item{control}{an optional list of control settings. See GOF.control for the names of the settable control values and their effect.}
}
\description{
QQ-norm GOF qqnorm plots with reference line
and caption added as reurned by get.caption
}
\examples{
dd<-data.frame(CWRES=rnorm(100))
qqnormGOF(dd,"CWRES")
}
