% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runrecord.R
\name{as.problem}
\alias{as.problem}
\title{Parse the Run Record}
\usage{
as.problem(x, ...)
}
\arguments{
\item{x}{character}

\item{...}{passed arguments}
}
\description{
Parses the run record portion of a problem statement in a NONMEM model.
stores it as an attribute of the problem statement.
See \url{https://github.com/UUPharmacometrics/PsN/releases/download/4.9.0/runrecord_userguide.pdf}.
}
\examples{
x <- 
'$PROB Simpraz - full data set
;; 1. Based on: 1
;; 2. Description:
;;    Added an OMEGA BLOCK(2) for CL and V
;; 3. Label:
;;    Basic model
;; 4. Structural model:
;;    One compartment linear model
;; 5. Covariate model:
;;    No covariates
;; 6. Interindividual variability:
;;    CL, V and KA. BLOCK(2) for CL and V
;; 7. Interoccasion variability:
;; 8. Residual variability:
;;    Proportional
;; 9. Estimation:
;;    FO'
con <- textConnection(x)
y <- readLines(con)
close(con)
z <- as.problem(y)
at <- attr(z,'problem')
names(at)
z
}
\seealso{
Other problem: 
\code{\link{problem.character}()},
\code{\link{problem.numeric}()},
\code{\link{problem_}()},
\code{\link{problem}()}
}
\concept{problem}
\keyword{internal}
