% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp_test.R
\name{rp.sample}
\alias{rp.sample}
\title{Generates a test statistics sample of random projections.}
\usage{
rp.sample(y, k = 1, pars1 = c(100,1), pars2 = c(2,7), seed = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a
stationary time series.}

\item{k}{an integer that determines the `2k` random projections are used for
every type of test. The `pars1` argument generates the first `k` projections,
and `pars2` generates the later `k` projections. By default, \code{k = 1}.}

\item{pars1}{an optional real vector with the shape parameters of the beta
distribution used for the first `k` random projections By default,
\code{pars1 = c(100,1)} where, \code{shape1 = 100} and \code{shape2 = 1}.}

\item{pars2}{an optional real vector with the shape parameters of the beta
distribution used to compute the last `k` random projections. By default,
\code{pars2 = c(2,7)} where, \code{shape1 = 2} and \code{shape2 = 7}.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}
}
\value{
A list with 2 real value vectors:
 \item{lobato:}{A vector with the Lobato and Velasco's statistics sample.}
 \item{epps:}{A vector with the Epps statistics sample.}
}
\description{
Generates a 4k sample of test statistics  projecting the stationary process
using the random projections procedure.
}
\details{
The \code{rp.sample} function generates `4k` tests statistics by projecting
the time series using `2k` stick breaking processes. First, the function
samples a stick breaking process using \code{pars1} argument. Then, projects
the time series using the sampled stick process. Later, applies both the Lobato
and Velasco's, and the Epps statistics to the obtained projection. Analogously,
the function performs the three steps using also \code{pars2} argument

The function uses beta distributions for generating the `2k` random projections.
By default, uses a \code{beta(shape1 = 100,shape = 1)} distribution contained
in \code{pars1} argument to generate the first `k` projections. For the later
`k` projections the functions uses a \code{beta(shape1 = 2,shape = 7)} distribution
contained in \code{pars2} argument.

The test was proposed by \emph{Nieto-Reyes, A.,Cuesta-Albertos, J. & Gamboa, F. (2014)}.
}
\examples{
# Generating an stationary ARMA process
y = arima.sim(100,model = list(ar = 0.3))
rp.sample(y)

}
\references{
Nieto-Reyes, A., Cuesta-Albertos, J. & Gamboa, F. (2014). A random-projection
based test of Gaussianity for stationary processes. \emph{Computational
Statistics & Data Analysis, Elsevier}, vol. 75(C), pages 124-141.

Epps, T.W. (1987). Testing that a stationary time series is Gaussian. \emph{The
Annals of Statistic}. 15(4), 1683-1698.

Lobato, I., & Velasco, C. (2004). A simple test of normality in time series.
\emph{Journal of econometric theory}. 20(4), 671-689.
}
\seealso{
\code{\link{lobato.test}}, \code{\link{epps.test}}
}
\author{
Alicia Nieto-Reyes and Asael Alonzo Matamoros
}
