% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_tests.R
\name{cvm_bootstrap.test}
\alias{cvm_bootstrap.test}
\title{The Sieve Bootstrap Cramer Von Mises test for normality.}
\usage{
cvm_bootstrap.test(y, reps = 1000, h = 100, seed = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a
stationary time series.}

\item{reps}{an integer with the total bootstrap repetitions.}

\item{h}{an integer with the first \code{burn-in} sieve bootstrap replicates.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}
}
\value{
A list with class \code{"h.test"} containing the following components:
 \item{statistic:}{the sieve bootstrap Cramer Von Mises' statistic.}
 \item{p.value:}{the p value for the test.}
 \item{alternative:}{a character string describing the alternative hypothesis.}
 \item{method:}{a character string \dQuote{Sieve-Bootstrap Cramer Von Mises' test}.}
 \item{data.name:}{a character string giving the name of the data.}
}
\description{
Performs the approximated Cramer Von Mises test of normality for univariate time series.
Computes the p-value using Psaradakis and Vavra's (2020) sieve bootstrap procedure.
}
\details{
Employs Cramer Von Mises test approximating the p-value using
a sieve-bootstrap procedure, \emph{Psaradakis, Z. and Vávra, M. (2020)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
cvm_bootstrap.test(y)

}
\references{
Psaradakis, Z. and Vávra, M. (2020) Normality tests for dependent
data: large-sample and bootstrap approaches. Communications in
\emph{Statistics-Simulation and Computation 49 (2)}. ISSN 0361-0918.

Bulmann, P. (1997). Sieve Bootstrap for time series. \emph{Bernoulli}.
3(2), 123 -148.

Stephens, M.A. (1986): Tests based on EDF statistics. In: D'Agostino,
R.B. and Stephens, M.A., eds.: Goodness-of-Fit Techniques. Marcel Dekker,
New York.
}
\seealso{
\code{\link{vavra.test}}, \code{\link{sieve.bootstrap}}
}
\author{
Asael Alonzo Matamoros.
}
