% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notify.R
\name{notify}
\alias{notify}
\title{Create a desktop notification}
\usage{
notify(msg, title = "R notification", image = NULL)
}
\arguments{
\item{msg}{Message to show. It may contain newline characters.}

\item{title}{Message title. Typically shown on the top, with
larger font.}

\item{image}{Image to show in the notification. By default the
official R logo is shown on macOS, and an alternative logo is shown
on other OSes, because of licensing reasons. You can specify a PNG
file here, to show instead of the R logo. This currently does not
work on older Windows versions (before Windows 8), which does not
allow PNG files, only ICO icons.}
}
\description{
How exactly the notification appears is platform dependent:
\itemize{
\item On macOS, we use the \code{terminal-notifier} tool, see
https://github.com/julienXX/terminal-notifier
\item On Linux and *BSD systems, including Solaris the \code{notify-send}
command line tool is used. This requires the \code{libnotify-bin}
package on Ubuntu/Debian and similar systems, or the \code{libnotify}
package on RedHat/CentOS/Fedora and similar systems.
\item On Windows 8 or newer Windows versions we use the \code{toaster} tool,
see https://github.com/nels-o/toaster.
\item On older Windows versions we use the \code{notifu} program, see
https://www.paralint.com/projects/notifu.
}
}
\details{
All notification systems support showing a title and an image,
as part of the notification.
}
\examples{
\dontrun{
notify("Hello world!")
notify("Hello world!", title = "Introduction")
notify("Hello world!", title = "Introduction", image = "mylogo.png")
}
}

