% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R
\name{nse.cos}
\alias{nse.cos}
\title{Long-run variance estimation using low-frequency cosine series.}
\usage{
nse.cos(x, q = 12, lag.prewhite = 0)
}
\arguments{
\item{x}{A numeric vector.}

\item{q}{Number of consine series.}

\item{lag.prewhite}{Prewhite the series before analysis (integer or \code{NULL}). When \code{lag.prewhite = NULL} this performs automatic lag selection. Default is \code{lag.prewhite = 0} that is no prewhitening.}
}
\value{
The NSE estimator.
}
\description{
Function which calculates the numerical standard error with low-frequency cosine weighted averages of the original serie.
}
\details{
The method estimate the series with a linear regression using cosine low frequency series. It than derived the NSE from the coefficient of the cosine series (Ulrich and Watson, 2017).
}
\examples{
n    = 1000
ar   = 0.9
mean = 1
sd   = 1
set.seed(1234)
x = as.vector(arima.sim(n = n, list(ar = ar), sd = sd) + mean)

nse.cos(x = x, q = 12, lag.prewhite = 0)
#' nse.cos(x = x, q = 12, lag.prewhite = NULL)
}
\references{
Muller, Ulrich K., and Mark W. Watson. (2015)
Low-frequency econometrics.
\emph{National Bureau of Economic Research}, No. w21564.
}
\author{
David Ardia and Keven Bluteau
}
