% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-stock.R
\name{nse_stock_high_low}
\alias{nse_stock_high_low}
\alias{nse_stock_year_high}
\alias{nse_stock_year_low}
\title{52 week high & low}
\usage{
nse_stock_year_high(clean_names = TRUE)

nse_stock_year_low(clean_names = TRUE)
}
\arguments{
\item{clean_names}{Logical; if \code{TRUE}, makes the column names
descriptive and uses snake_case.}
}
\value{
A tibble with the following column names:

\item{symbol}{NSE ticker.}
\item{symbol_desc}{Name of the firm.}
\item{date}{Previous high date.}
\item{new_high}{New 52 week high price.}
\item{new_low}{New 52 week low price.}
\item{year}{Year.}
\item{last_traded_price}{Last traded price.}
\item{prev_high}{Previous high price.}
\item{prev_low}{Previous low price.}
\item{prev_close}{Previous close price.}
\item{change}{Change in price.}
\item{percent_change}{Percentage change in price.}
}
\description{
Fetch stocks that have touched their 52 week high and low.
}
\examples{
\dontrun{
# 52 week high
nse_stock_year_high()

# retain original column names as returned by NSE
nse_stock_year_high(clean_names = FALSE)

# 52 week low
nse_stock_year_low()

# retain original column names as returned by NSE
nse_stock_year_low(clean_names = FALSE)
}

}
