% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmr.R
\name{bmr}
\alias{bmr}
\title{Basal Metabolic Rate}
\usage{
bmr(weight, age, fat, height, activity = 1.45, method = "msj", gender = "male")
}
\arguments{
\item{weight}{weight, in kilograms}

\item{age}{age, in years}

\item{fat}{fat proportion in body}

\item{height}{height, in centimeters}

\item{activity}{activity level (a scalar between 1 and 2)}

\item{method}{calculation method ("msj" for Mifflin-St. Jeor or "kma" for
Katch-McArdle)}

\item{gender}{"male" or "female"}
}
\value{
The Basal Metabolic Rate, in kilocalories
}
\description{
Estimates the basal metabolic rate of a person.
}
\examples{
bmr(67, 40, .12, 178) # for an individual with 12\% body fat
}
\references{
https://www.calculator.net/bmr-calculator.html

Mifflin, M. D., St Jeor, S. T., Hill, L. A., Scott, B. J., Daugherty, S. A.,
& Koh, Y. O. (1990). A new predictive equation for resting energy expenditure
in healthy individuals. The American journal of clinical nutrition, 51(2),
241-247.

McArdle, W. D., Katch, F. I., & Katch, V. L. (2010). Exercise physiology:
nutrition, energy, and human performance. Lippincott Williams & Wilkins.
}
\author{
Waldir Leoncio
}
