% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zyx2R.R
\name{zyx2R}
\alias{zyx2R}
\title{Create a rotation matrix from 3 angles about new axes in the zyx order.}
\usage{
zyx2R(z, y, x)
}
\arguments{
\item{z}{Angle of rotation about new z axis}

\item{y}{Angle of rotation about new y axis}

\item{x}{Angle of rotation about new x axis}
}
\value{
3x3 rotation matrix R_AB (direction cosine matrix) such that the
        relation between a vector v decomposed in A and B is
        given by: v_A = R_AB * v_B
}
\description{
The rotation matrix \code{R_AB} is created based on 3 angles \code{z}, \code{y} and \code{x}
about new axes (intrinsic) in the order z-y-x.
The angles (called Euler angles or Tait–Bryan angles) are defined by the following procedure
of successive rotations:
\enumerate{
   \item Given two arbitrary coordinate frames A and B, consider a temporary frame
         T that initially coincides with A. In order to make T align with B, we
         first rotate T an angle z about its z-axis (common axis for both A and T).
   \item Secondly, T is rotated an angle y about the NEW y-axis of T.
   \item Finally, T is rotated an angle x about its NEWEST x-axis.
         The final orientation of T now coincides with the orientation of B.
}
 The signs of the angles are given by the directions of the axes and the right hand rule.
 Note that if A is a north-east-down frame and B is a body frame, we
 have that z=yaw, y=pitch and x=roll.
}
\examples{
zyx2R(rad(30), rad(20), rad(10))

}
\references{
Kenneth Gade \href{www.navlab.net/Publications/A_Nonsingular_Horizontal_Position_Representation.pdf}{A Nonsingular Horizontal Position Representation}.
\emph{The Journal of Navigation}, Volume 63, Issue 03, pp 395-417, July 2010.
}
\seealso{
\code{\link{R2zyx}}, \code{\link{xyz2R}} and \code{\link{R2xyz}}.
}
