% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo.R
\name{demo_shiny}
\alias{demo_shiny}
\title{Run demo shiny app}
\usage{
demo_shiny(host = "0.0.0.0", port = 3838)
}
\arguments{
\item{host}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not. See
Details.}

\item{port}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port between 3000:8000, excluding ports that are blocked
by Google Chrome for being considered unsafe: 3659, 4045, 5060,
5061, 6000, 6566, 6665:6669 and 6697. Up to twenty random
ports will be tried.}
}
\description{
Runs a Shiny application. This function normally does not return; interrupt R
to stop the application (usually by pressing Ctrl+C or Esc).
}
\examples{
\dontrun{
  demo_shiny()
  demo_shiny("127.0.0.1", 80)
}

}
