% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/needleman-wunsch.R
\name{alignS}
\alias{alignS}
\title{Align 2 sequences.}
\usage{
alignS(s.matrix, gap = -1)
}
\arguments{
\item{s.matrix}{Similarity matrix. See sMatrix(...).}

\item{gap}{Penality assigned to a gap (missing or extra value).}
}
\value{
2 column matrix. First column = similarity matrix rows
(first sequence), Second column = similarity matrix columns
(second sequence). Each row maps aligned indexs from each sequence:

\preformatted{
  > a <- c(2,4,5)
  > b <- 1:5
  > alignS(sMatrix(a,b))
       a b
  [1,] 1 2
  [2,] 2 4
  [3,] 3 5
}
}
\description{
Verbatim implementation of Needleman-Wunsch matching algorithm.
}
\examples{
\dontrun{

a <- c(2,4,5)
b <- 1:5
alignS(sMatrix(a, b))

}
}
\author{
phil
}
\references{
\url{https://en.wikipedia.org/wiki/Needleman-Wunsch_algorithm}
}
\keyword{internal}

