% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms.R
\name{ocd_update}
\alias{ocd_update}
\title{Processing a new data point for the 'OCD' class}
\usage{
ocd_update(x_new, A, tail, beta, sparsity)
}
\arguments{
\item{x_new}{a new data point}

\item{A}{matrix of tail CUSUMs that will be tracked and updated online}

\item{tail}{matrix of tail lengths that will be tracked and updated online}

\item{beta}{a user specified lower bound on the l_2 norm of the vector of
change to be detected.}

\item{sparsity}{a user specified mode parameter. If the vector of change is
known to be dense or sparse, then one should set sparsity to 'dense' or 'sparse'
accordingly, otherwise, the default choice sparsity='auto' will run the algorithm
adaptive to the sparsity level.}
}
\value{
a list of
\itemize{
\item stat: a vector of the test statistics for the 'OCD' class
\item A: the updated A matrix
\item tail: the updated tail matrix
}
}
\description{
This function implements the \code{\link{getData}} function to
perform the online changepoint detection for the 'OCD' class.
}
\references{
Chen, Y., Wang, T. and Samworth, R. J. (2020) High-dimensional multiscale
online changepoint detection \emph{Preprint}. arxiv:2003.03668.
}
