% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{numberAsPOSIXct}
\alias{numberAsPOSIXct}
\title{Convert a Numeric Time to a POSIXct Time}
\usage{
numberAsPOSIXct(t, type = c("unix", "matlab", "gps", "argo", "ncep1", "ncep2",
  "sas", "spss", "yearday"), tz = "UTC")
}
\arguments{
\item{t}{an integer corresponding to a time, in a way that depends on
\code{type}.}

\item{type}{the type of time (see \dQuote{Details}).}

\item{tz}{a string indicating the time zone, used only for unix and matlab
times, since GPS times are always referenced to the UTC timezone.}
}
\value{
A \code{\link{POSIXct}} time vector.
}
\description{
There are many varieties, according to the value of \code{type} as defined
in \sQuote{Details}.
}
\details{
\itemize{

\item \code{"unix"} employs Unix times, measured in seconds since the start
of the year 1970.

\item \code{"matlab"} employs Matlab times, measured in days since what
MathWorks [1] calls ``January 0, 0000'' (i.e.  \code{ISOdatetime(0, 1, 1, 0,
0, 0)} in R notation).

\item \code{"gps"} employs the GPS convention. For this, \code{t} is a
two-column matrix, with the first column being the the GPS "week"
(referenced to 1999-08-22) and the second being the GPS "second" (i.e. the
second within the week).

\item \code{"argo"} employs Argo times, measured in days since the start of
the year 1900.

\item \code{"ncep1"} employs NCEP times, measured in hours since the start
of the year 1800.

\item \code{"ncep2"} employs NCEP times, measured in days since the start of
the year 1. (Note that, for reasons that are unknown at this time, a simple
R expression of this definition is out by two days compared with the UDUNITS
library, which is used by NCEP. Therefore, a two-day offset is applied. See
[2,3].)

\item \code{"sas"} employs SAS times, indicated by \code{type="sas"}, have
origin at the start of 1960.

\item \code{"spss"} employs SPSS times, in seconds after 1582-10-14.

\item \code{"yearday"} employs a convention in which \code{t} is a
two-column matrix, with the first column being the year, and the second the
yearday (starting at 1 for the first second of January 1, to match the
convention used by Sea-Bird CTD software).

}
}
\examples{

numberAsPOSIXct(0)                     # unix time 0
numberAsPOSIXct(1, type="matlab")      # matlab time 1
numberAsPOSIXct(cbind(566,345615), type="gps") # Canada Day
numberAsPOSIXct(cbind(2013, 0), type="yearday") # start of 2013

}
\author{
Dan Kelley
}
\references{
[1] Matlab times:
\url{http://www.mathworks.com/help/matlab/ref/datenum.html}

[2] NCEP times: \url{http://www.esrl.noaa.gov/psd/data/gridded/faq.html#3}

[3] problem with NCEP times:
\url{https://github.com/dankelley/oce/issues/738}
}
\seealso{
\code{\link{numberAsHMS}}

Other things related to time: \code{\link{ctimeToSeconds}},
  \code{\link{julianCenturyAnomaly}},
  \code{\link{julianDay}}, \code{\link{numberAsHMS}},
  \code{\link{oce.as.POSIXlt}},
  \code{\link{secondsToCtime}},
  \code{\link{unabbreviateYear}}
}

