% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapScalebar}
\alias{mapScalebar}
\title{Add a Scalebar to a Map}
\usage{
mapScalebar(x, y = NULL, length, lwd = 1.5 * par("lwd"), cex = par("cex"),
  col = "black")
}
\arguments{
\item{x, y}{position of the scalebar.  Eventually this may be similar to
the corresponding arguments in \code{\link{legend}}, but at the moment
\code{y} must be \code{NULL} and \code{x} must be \code{"topleft"}.}

\item{length}{the distance to indicate, in kilometres.  If not provided, a
reasonable choice is made, based on the underlying map.}

\item{lwd}{line width of the scalebar.}

\item{cex}{character expansion factor for the scalebar text.}

\item{col}{colour of the scalebar.}
}
\description{
Draw a scalebar on an existing map.
}
\details{
The scale is appropriate to the centre of the plot, and will become
increasingly inaccurate away from that spot, with the error depending on
the projection and the fraction of the earth that is shown.
}
\examples{
\dontrun{
library(oce)
## Arctic Ocean
data(coastlineWorld)
latlim <- 90 + 25 * c(-1, 1)
lonlim <- c(-130, -50)
orientation <- c(90, -90, 0)
proj <- "stereographic"
fill <- "lightgray"
mapPlot(coastlineWorld, latitudelim=latlim, longitudelim=lonlim,
        proj=proj, orientation=orientation,
        axes=FALSE, fill=fill)
mapScalebar()
}
}
\author{
Dan Kelley
}
\seealso{
A map must first have been created with \code{\link{mapPlot}}.

Other functions related to maps: \code{\link{lonlat2map}},
  \code{\link{lonlat2utm}}, \code{\link{map2lonlat}},
  \code{\link{mapArrows}}, \code{\link{mapAxis}},
  \code{\link{mapContour}},
  \code{\link{mapDirectionField}}, \code{\link{mapGrid}},
  \code{\link{mapImage}}, \code{\link{mapLines}},
  \code{\link{mapLocator}},
  \code{\link{mapLongitudeLatitudeXY}},
  \code{\link{mapPlot}}, \code{\link{mapPoints}},
  \code{\link{mapPolygon}}, \code{\link{mapText}},
  \code{\link{mapTissot}}, \code{\link{oceCRS}},
  \code{\link{shiftLongitude}}, \code{\link{utm2lonlat}}
}

